<?php
/*
Plugin Name: Hide Internal Tags
Description: Piilottaa tietyt metatagit vierailijoilta (esim. 'translate', 'translated').
Version: 1.0
Author: Sinä
*/

defined('ABSPATH') or die('Ei pääsyä suoraan tiedostoon.');

// 1. Piilota tagit artikkeleista
function hit_hide_internal_tags($terms, $post_id, $taxonomy) {
    if ($taxonomy !== 'post_tag' || is_admin()) {
        return $terms;
    }

    $hidden_tags = ['translate', 'translated'];

    return array_filter($terms, function($term) use ($hidden_tags) {
        return !in_array($term->slug, $hidden_tags);
    });
}
add_filter('get_the_terms', 'hit_hide_internal_tags', 10, 3);

// 2. Estä tagiarkistot näkymästä
function hit_redirect_hidden_tag_archives() {
    if (is_tag(['translate', 'translated'])) {
        wp_redirect(home_url(), 301);
        exit;
    }
}
add_action('template_redirect', 'hit_redirect_hidden_tag_archives');

// 3. Lisää noindex meta
function hit_noindex_meta_for_hidden_tags() {
    if (is_tag(['translate', 'translated'])) {
        echo '<meta name="robots" content="noindex, nofollow">';
    }
}
add_action('wp_head', 'hit_noindex_meta_for_hidden_tags');

// 4. (Valinnainen) Piilota REST API:sta
/*
function hit_hide_tags_from_rest($response, $term, $request) {
    $hidden_tags = ['translate', 'translated'];
    if (in_array($term->slug, $hidden_tags)) {
        return null;
    }
    return $response;
}
add_filter('rest_prepare_post_tag', 'hit_hide_tags_from_rest', 10, 3);
*/
